/* Copyright (C) 1992 Imperial College */
/* macros used in garbage collection */
#define mark_bit	0x00000001
#define mark_mask	0xfffffffe
#define first_bit	0x00000002
#define first_mask	0xfffffffd

#define mark(addr)	(*(addr) |= mark_bit)
#define head(addr)	(*(addr) |= first_bit)
#define unmark(addr)	(*(addr) &= mark_mask)
#define unhead(addr)	(*(addr) &= first_mask)
#define marked(addr)	(*(addr) & mark_bit)
#define first(addr)	(*(addr) & first_bit)
