/* Copyright (C) 1992 Imperial College */
/*	Run-time system for class template programming

	
	Authors : F.G. McCabe, D.A. Chu, Y. Cosmadopoulos
			(Started Nov 1988)
	
	Based on the Warren abstract machine (Heresy!!) machine with 
	modifications to allow for
	multiple labels and for multiple threads

	usage -
	icp [-d] [-b boot_file] [ -h heapsize ] [ -s stacksize ]

	heap and stack sizes are in K cells
 */

#include "icp.h"
#include "io.h"
#include "symtab.h"
#include "events.h"
#include "version.h"

/* default boot file */
#define BOOT	"boot.icp"

/* default heap size is 48K */
#ifndef HEAPSIZE
#define	HEAPSIZE	0xc000L
#endif

/* default stack size is 16K */
#ifndef STACKSIZE
#define	STACKSIZE	0x4000L
#endif

/* default architecture is Sparc */
#ifndef ARCH
#define	ARCH		"sun4"
#endif

#if !defined(THINK_C) && !defined(GNUDOS)
#include <sys/time.h>
#define INIT_SEC	0L
#define INIT_MICRO	300000L
#define INTERVAL_SEC	0L
#define INTERVAL_MICRO	100000L
static
struct itimerval interval= {
				{ INTERVAL_SEC, INTERVAL_MICRO },
				{ INIT_SEC    , INIT_MICRO     }
			   };
#endif
#define ICP_STARTUP	"~/.icp.pl"
#define PAR_STARTUP	"~/.icp.par"

extern bool	pr_fix_tables();
extern threadpo newthread();
extern bool	init_cg();
extern bool	init_props();
extern bool	init_loader();
extern bool	loadicp();
extern void	sig_int();
extern void	sig_vtalrm();
extern codepo	search_symbol();
extern FILE	*open_ic_file();

extern cell	A[REGISTERS];
extern threadpo	TH;
extern eventpt	eventq;
extern symbpo	boot_sym;

#ifdef HERMES
extern int	jam_argc;
extern char	*jam_argv[];
extern int	*event;
/*
 * 'event' is a pointer to an integer.  It is initialised and used by
 * Parlog.  However in case Parlog is not started, we need to initialise
 * it to point to some valid value.  Hence we declare tmp_event here.
 */
int	tmp_event = 0;
#endif

threadpo	prolog_th,
		parlog_th = NULL;

codepo		boot;
int		debugLevel = 0,
		oldLevel = 0;

fourBytes	init_heapsize = 0L, init_stacksize = 0L;

void	(*tcp_exit) () = NULL;

void icp_exit(flag)
int flag;
{
	extern void exit();

	if (tcp_exit)
		tcp_exit();
	exit(flag);
}


/*
 *  The main program
 */
main(argc, argv)
int	argc;
char	**argv;
{
	threadpo	th;
	char		*bootname = NULL;
	FILE		*bootfile;
	char		*icp_argv[256],
			*par_argv[256],
			*startup_prolog[2],
			*startup_parlog[2],
			*charset = NULL;
	int		icp_argc=0,
			par_argc=0;
	bool		pro_startupfile = TRUE,
			par_startupfile = TRUE;

#ifdef HERMES
	event = &tmp_event;
#endif

	/* to allow dynamic loading of C primitives */
	initialise_load_foreign(argv[0]);

#ifdef THINK_C
	argc = ccommand(&argv);
#endif

	startup_prolog[0] = ICP_STARTUP;
	startup_prolog[1] = NULL;
	startup_parlog[0] = PAR_STARTUP;
	startup_parlog[1] = NULL;
	while (--argc > 0) {
		if ((*++argv)[0] == '-') {
			switch ((*argv)[1]) {
			case 'b':
				bootname = *++argv;
				argc--;
				break;
			case 'd':	/* OBSOLETE !  Do not offer to user */
				debugLevel = STARTLEVEL;
				oldLevel = STARTLEVEL;
				break;
			case 'h':
				if ((*argv)[2])
					init_heapsize = atoi(*argv+2) * 1024;
				else if (--argc)
					init_heapsize = atoi(*++argv) * 1024;
				if (!init_heapsize) {
					(void) fprintf(stderr, "icp: invalid heap size specified\n");
					icp_exit(1);
				}
				break;
			case 'f':
				if ((*argv)[2] == 'f') {
					if ((*argv)[3])
						startup_parlog[0] = *argv+3;
					else {
						startup_parlog[0] = *++argv;
						argc--;
					}
				}
				else if ((*argv)[2])
					startup_prolog[0] = *argv+2;
				else {
					startup_prolog[0] = *++argv;
					argc--;
				}
				break;
			case 's':
				if ((*argv)[2])
					init_stacksize = atoi(*argv+2) * 1024;
				else if (--argc)
					init_stacksize = atoi(*++argv) * 1024;
				if (!init_stacksize) {
					(void) fprintf(stderr, "icp: invalid stack size specified\n");
					icp_exit(1);
				}
				break;
			case 'z':
				if ((*argv)[2] == 'z') {
					if ((*argv)[3])
						par_argv[par_argc++] = *argv+3;
					else {
						par_argv[par_argc++] = *++argv;
						argc--;
					}
				}
				else if ((*argv)[2])
					icp_argv[icp_argc++] = *argv+2;
				else {
					icp_argv[icp_argc++] = *++argv;
					argc--;
				}
				break;
			case 'n':
				if ((*argv)[2] == 'n')
					par_startupfile = FALSE;
				else
					pro_startupfile = FALSE;
				break;
			case 'F':
				if ((*argv)[2])
					charset = *argv+2;
				else {
					charset = *++argv;
					argc--;
				}
				break;
#ifdef HERMES
			default:
				jam_argv[jam_argc++] = *argv;
#endif
			}
		}
#ifdef HERMES
		else jam_argv[jam_argc++] = *argv;
#endif
	}
	icp_argv[icp_argc] = NULL;
	par_argv[par_argc] = NULL;

	(void) fprintf(stderr, "\n\n");
	(void) fprintf(stderr, "IC-Prolog ][ version %s -  %s\n",
			VERSION, VERSION_DATE);
	(void) fprintf(stderr, "Copyright (C) 1991-1993 Imperial College\n\n");

	if (!init_heapsize)
		init_heapsize = HEAPSIZE;
	if (!init_stacksize)
		init_stacksize = STACKSIZE;

	if (!(prolog_th=newthread(init_heapsize, init_stacksize))) {
		(void) fprintf(stderr, "icp: insufficient space to create thread\n");
		icp_exit(1);
	}

	prolog_th->prev = prolog_th;	/* initialise linked list */
	prolog_th->next = prolog_th;

	/* use default file if none given */
	if (bootname == NULL)
		bootname = BOOT;

	init_charset(charset);
	init_instr();
	init_global_syms();
	init_dynamic();
	init_select();
	if  (!init_cg() || !init_props() || !init_loader()) {
		(void) fprintf(stderr,"icp: insufficient space to run IC-Prolog ][\n");
		icp_exit(1);
	}
	initialise_directories();

	bootfile = open_ic_file(bootname, READBIN, TRUE);
	if (bootfile == NULL) {
		(void) fprintf(stderr, "icp: '%s' not found\n", bootname);
		icp_exit(1);
	}

	/* load the boot program ... */
	current_input = io;
	io_type(current_input) = IN_STREAM;
	fdes(current_input) = bootfile;
	charin = pr_read_stream;
	timeslice(0);
	if (!loadicp(SYSTEM)) {
		(void) fprintf(stderr, "icp: error loading boot file %s\n", bootname);
		icp_exit(1);
	}
	timeslice(1);
	(void) fclose(bootfile);
	(void) pr_fix_tables();

	boot = segStart(newseg);
	init_io();

	/* ... and run it */
	th = prolog_th;
	th->P = search_symbol(boot_sym, 0);
	(void) add_to_runq(prolog_th, FALSE);

	/* set up interrupts */
	(void)signal(SIGINT, sig_int);
	(void)signal(SIGPIPE, SIG_IGN);

#if !defined(THINK_C) && !defined(GNUDOS)
	/* set up the interval timer to give time-slices */
	(void)setitimer(ITIMER_VIRTUAL, &interval, (struct itimerval *)NULL);
	(void)signal(SIGVTALRM, sig_vtalrm);
#endif


	set_str_prop("$prolog$", "$argv$", icp_argv);
	set_str_prop("$parlog$", "$argv$", par_argv);
	if (pro_startupfile)
		set_str_prop("$prolog$", "$file$", startup_prolog);
	if (par_startupfile)
		set_str_prop("$parlog$", "$file$", startup_parlog);
	set_prolog_path();
	for (;;) {
		if (eventq)
			(void) event_handler(FALSE);

#ifdef HERMES
		if (!th->prolog)	/* parlog */
			hermes_top(th);
		else
#endif
		{
			load_thread(th);
			(void) solve(th->P);
		}
		th = next_thread(th);
	}
	icp_exit(0);
}
