/* Copyright (C) 1992 Imperial College */
/* A listing of all the opcodes */
#define	halt		0		/* stop execution */
#define	succ		1		/* succeed clause */
#define jmp		2		/* local last call */
#define	execute		3		/* external last call */
#define	executev	4		/* meta last call */
#define jsr		5		/* local call */
#define callme		6		/* inline call */
#define	call		7		/* call an external procedure */
#define	callv		8		/* meta call */
	
#define	allocate	9		/* allocate a call record and local environment */
#define	deallocate	10		/* deallocate the call record */

#define	tryme		11		/* try a clause */
#define	retryme		12		/* try subseqeunt clause */
#define	trustme		13		/* last clause to try */

#define	try		14		/* try a clause */
#define	retry		15		/* try a subseqeunt clause */
#define	trust		16		/* last clause to try */

#define	fail		17		/* fail execution */

#define	arg_switch	18		/* switch on argument register */

#define	indexc		19		/* index constant symbol access */
#define	indexi		20		/* index integer access */
#define	indext		21		/* index tuple access */

/* put instructions */

#define clr_y_var       22              /* initialises local variable */
#define	put_x_var	23		/* put a new variable in argument register and temporary */
#define	put_y_var	24		/* put a new variable in local variable */

#define	put_x_val	25		/* copy argument register to argument register */
#define	put_y_val	26		/* copy contents of local into argument register */

#define	put_unsafe_y	27		/* last occ. of an unsafe variable in arg reg.*/

#define	put_void	28		/* put a void variable into argument register */
#define	put_const	29		/* put a constant into argument register */
#define	put_int		30		/* put an integer into argument register */
#define	put_nil		31		/* put nil into argument register */	
#define	put_list	32		/* put list pair into argument register */
#define	put_tpl		33		/* put a tuple into argument register */
#define	put_slash	34		/* store slashback in argument register */

/* get instructions */

#define	get_x_var	35		/* move argument register */
#define	get_y_var	36		/* move arg to local env */

#define	get_x_val	37		/* unify subsequent occ. of x var. */
#define	get_y_val	38		/* subsequent occ. of arg in local */

#define	get_const	39		/* unify arg register with a constant symbol */
#define	get_int		40		/* unify arg register with an integer */
#define	get_nil		41		/* unify arg register with nil */	
#define	get_list	42		/* unify arg register with a list pair */	
#define	get_tpl		43		/* unify arg register with a tuple(structure) */
	
/* unify instructions */

#define	unify_void	44		/* skip some terms */
	
#define	unify_x_var	45		/* new var in structure against arg register */
#define	unify_y_var	46		/* new var in structure against local var */
	
#define	unify_x_val	47		/* unify var structure against arg register */
#define	unify_y_val	48		/* unify var in structure against local var */
	
#define	unify_loc_x_val	49		/* unify local value against arg register */
#define	unify_loc_y_val	50		/* unify local value against local var */
	
#define	unify_const	51		/* unify against constant symbol */
#define	unify_int	52		/* unify agaist integer */	
#define	unify_nil	53		/* unify against nil */
#define	unify_list	54		/* unify against list */
#define	unify_tpl	55		/* unify against tuple */

#define	push_t		56		/* push term pointer */
#define	pop_t		57		/* pop term pointer */
#define cut		58		/* trim choice points */
#define gc		59		/* garbage collection */
	
#define brkinstr	60		/* break point service */

#define escape		61		/* escape into service functions */

#define data		62		/* data for inline jsr */

#define	f_push_t	63		/* first push term pointer */
#define	dynamic		64		/* dynamic instruction */
#define	fdynamic	65		/* first dynamic */

/* set instructions */

#define	set_void	66		/* skip some terms */
	
#define	set_x_var	67		/* new var in structure against arg register */
#define	set_y_var	68		/* new var in structure against local var */
	
#define	set_x_val	69		/* unify var structure against arg register */
#define	set_y_val	70		/* unify var in structure against local var */
	
#define	set_loc_x_val	71		/* unify local value against arg register */
#define	set_loc_y_val	72		/* unify local value against local var */
	
#define	set_const	73		/* unify against constant symbol */
#define	set_int		74		/* unify agaist integer */	
#define	set_nil		75		/* unify against nil */
#define	set_list	76		/* unify against list */
#define	set_tpl		77		/* unify against tuple */
#define	put_float	78		/* put a float into argument register */
#define	get_float	79		/* unify arg register with a float */
#define	unify_float	80		/* unify against a float */	
#define	set_float	81		/* unify against a float */	

#define	go_to		82		/* go to label */
#define	set_err		83		/* set error label */
#define	clr_err		84		/* clear error label */
#define	nop		85		/* no operation */
#define	nop2		86		/* no operation (2 words) */
#define	nop3		87		/* no operation (3 words) */
#define	gc_allocate	88		/* g/c + allocate */
#define	gc0		89		/* set up shadow HMAX */

/* have left a hole for new instructions (up to 99) */
#include "opcodes_low.h"

/* the two defines below must give the range of opcodes 
   for the call instructions (excluding last calls). */
#define LOW_CALL	5
#define HIGH_CALL	8
