/* Copyright (C) 1992 Imperial College */
/*
 * support for C primitives ( escape instructions )
 */

#include "primitives.h"

extern fourBytes collect_garbage();

/* Need to make sure that there is enough space for the symbols */
/* As a rough guide, allow 5 cells per symbol.			*/
#define SYMBOL_HEAPSIZE 2048
cell symbolHeap[SYMBOL_HEAPSIZE];

static cellpo localH = symbolHeap;



symbpo	fork_sym,
	rpc_sym,
	interrupt_sym,
	undef_sym,
	equals_sym,
	eof_sym,
	clause_sym,
	fail_sym,
	system_sym,
	user_sym,
	dynamic_sym,
	static_sym,
	external_sym,
	boot_sym,
	nested_sym,
	load_sym;



symbpo
define_symbol(sym)
char *sym;
{
    cellpo		H = localH;
    int			len;
    cell		tmp;

    len = strlen(sym);
    alloc_symb(&tmp, len, (strpo)sym);
    localH = H;
    if ((localH - symbolHeap) > SYMBOL_HEAPSIZE) {
	(void) fprintf(stderr, "out of symbol heap space\n");
	icp_exit(1);
    }
    return(symbvl(&tmp));
}

init_global_syms()
{
    fork_sym		= define_symbol("$fork$");
    rpc_sym		= define_symbol("$rpc$");
    interrupt_sym	= define_symbol("$interrupt$");
    undef_sym		= define_symbol("$undefined$");
    equals_sym		= define_symbol("=");
    eof_sym		= define_symbol("end_of_file");
    clause_sym		= define_symbol("$c$");
    fail_sym		= define_symbol("?fail?");
    system_sym		= define_symbol("system");
    user_sym		= define_symbol("user");
    dynamic_sym		= define_symbol("dynamic");
    static_sym		= define_symbol("static");
    external_sym	= define_symbol("external");
    boot_sym		= define_symbol("$ boot");
    nested_sym		= define_symbol("$nested$");
    load_sym		= define_symbol("<LOAD>");
}

cellpo
define_functor(sym, ar)
char *sym;
int ar;
{
	cellpo	H = localH;
	cellpo	var, tpl;

	alloc_cell(var);
	alloc_tpl(var, tpl, ar+1);
	localH = H;
	mksymb(tpl, define_symbol(sym));

	while(ar--) {
		tpl++;
		mkunb(tpl);
	}
	return (var);
}

bool
gc_test(size, regs)
fourBytes size;
short	  regs;
{
    if (H + size >= HMAX) {
	(void)collect_garbage(regs+1);
	if (H + size >= HMAX)
	    longjmp(icp_interrupt, 505);
	return(TRUE);
    }
    return(FALSE);
}

/*
   This constructs a symbol in the heap and binding it to
   an argument register.  The number of the relevant register
   is the first argument.  The second argument is the print
   name of the symbol and the third argument specifies how
   many registers are in use.  This is needed in case the
   garbage collector is called while constructing the symbol.
*/
bool
bind_symbol(Reg, cstring, Nreg)
int	Reg;
char	*cstring;
int	Nreg;
{
	int	len, numcells;
	bool	status;
	cellpo	term;

	len = strlen(cstring);
	numcells = symbSize(len, sizeof(cell));
	status = gc_test(numcells+2, Nreg);
	term = &A[Reg];
	delnk(term);
	mkreset(term);
	alloc_symb(term, len, (strpo)cstring);
	return(status);
}
