/* Copyright (C) 1992 Imperial College */
#include "primitives.h"
#include "symtab.h"
#include "dynamic.h"

extern codepo	find_clause();
extern symbpo	clause_sym;

static int save_count = 0;

#define addtoList(next, pred) {  alloc_list(next, next);	\
				mktpl(next, vl(pred));		\
				next++; }

bool save_static(dict)
dictionary dict;
{
    codepo	seg;
    short	len;
    if (segSaved(dict->seg) != save_count) {
	segSaved(dict->seg) = save_count;
	seg = segStart(dict->seg);
	len = *seg + 1;
	return(len == fwrite((char*)seg, 2, len, fdes(current_output)));
    } else return(SUCCEED); 
}

bool save_dynamic(clause, segno)
codepo clause;
segment segno;
{
    codepo	base, pred;
    twoBytes	len;

    base = clause - HEAD_SIZE;
    len = seg_len(base) + 1;

    /* saving foo/n clause */
    if (len != fwrite((char*)base, 2, len, fdes(current_output)))
    	return(FAIL);   

    pred = segExt(segno);
    clause = find_clause(clause_sym, 2, ext_pred(pred),
    			(twoBytes)ext_arity(pred), &len);
    base = clause - HEAD_SIZE;
    len = seg_len(base) + 1;

     /* saving $c$/2 clause */
    if (len != fwrite((char*)base, 2, len, fdes(current_output)))
    	return(FAIL);    
   
    clause = ext_dict(pred)->addr;
    findFirst(clause, C);
    while (clause) {
	base = clause - HEAD_SIZE;
    	len = seg_len(base) + 1;
	/* saving $c$foo/n+1 */
	if (len != fwrite((char*)base, 2, len, fdes(current_output)))
	    return(FAIL);
	findNext(clause, C);
    }
    return(SUCCEED);
}

bool pr_save()
{ 
    cellpo	list	= &A[1],
		saved	= &A[2],
		undef	= &A[3],
		nextsaved,
		nextundef,
		pred,
		name,
		arit,
		el = list;
    dictionary	dict;
    fourBytes	len = 0;
    codepo	clause;
				
    delnk(list);

    /* find length of list */
    while(IsList(el)) {
	len++;
	el = tl(el);
	delnk(el);
    }

    /* enough heap space ? */
    if (gc_test(2*len, 3)) {
	list = &A[1];
	delnk(list);
    }

    delnk(saved);
    delnk(undef);
	
    mkreset(saved);
    mkreset(undef);
	
    nextsaved = saved;
    nextundef = undef;

    save_count++;

    while (IsList(list)) {
	pred = hd(list);
	delnk(pred);
	if (IsTpl(pred)) {
	    name = arg(pred, 1);
	    arit = arg(pred, 2);
  	    delnk(name);
	    delnk(arit);
	    dict = find_entry(symbvl(name), (twoBytes)intvl(arit));
	}
	else if (IsSymb(pred))
	    dict = find_entry(symbvl(pred), 0);
	else dict = NULL;

	if (dict && dict->addr)
	    switch (dict->type) {
		case STATIC:
		    if (!save_static(dict))
			throw(305);
		    addtoList(nextsaved, pred);
		    break;
		case DYNAMIC:
		    clause = dict->addr;
		    findFirst(clause, C);
		    if (clause) {
			if (!save_dynamic(clause, dict->seg))
			    throw(305)
			else addtoList(nextsaved, pred);
		    }
		    else addtoList(nextundef, pred);
	    }
	else addtoList(nextundef, pred);
	list = tl(list);
	delnk(list);
    }

    mknil(nextsaved);
    mknil(nextundef);		
    return(SUCCEED);
}
