/* Copyright (C) 1992 Imperial College */
#include <sys/types.h>
#include <sys/time.h>

#ifdef HERMES
#	include <stdio.h>
#	include "../parlog/objs.h"
#	include "../parlog/stream.h"
#else
#	include "icp.h"
#endif
#include "select.h"

extern void (*thread_hook)();

time_t select_time = 0L;
int select_width = 0;
int h_deadlock = 0;
fd_set rfdset, wfdset, efdset;

struct  timeval timeout = { 0L, 0L };

set_select_time(ti)
time_t	ti;
{
	if (!select_time || ti < select_time)
		select_time = ti;
}

update_select_width(sock)
int	sock;
{
	if (sock >= select_width)
		select_width = sock+1;
}

wait_for_user()
{
	/* flush all events before blocking */
	event_handler(FALSE);

	/* some processes/threads might be unblocked now */
	if (!h_deadlock)
		return;

#ifdef HERMES
	if (h_deadlock & D_PARLOG) {
		FD_SET (fileno(st_user_input->st_fp), &rfdset);
		update_select_width(fileno(st_user_input->st_fp));
	}
#endif

	if (h_deadlock & D_PROLOG) {
		FD_SET (0, &rfdset);
		 update_select_width(0);
	}

	if (thread_hook) {
		/* wait at most 1/4 second */
		timeout.tv_sec = 0;
		timeout.tv_usec = 250000;
		select(select_width, &rfdset, &wfdset, &efdset, &timeout);
	}
	else if (select_time)
	{
		timeout.tv_sec = select_time - time(NULL);
		if (timeout.tv_sec < 0)
			timeout.tv_sec = 0L;
		select(select_width, &rfdset, &wfdset, &efdset, &timeout);
		select_time = 0;
	}
	else select(select_width, &rfdset, &wfdset, &efdset, NULL);

	h_deadlock = 0;
	FD_ZERO(&rfdset);
	FD_ZERO(&wfdset);
	FD_ZERO(&efdset);
}

nonempty_fdset()
{
	int width;

	width = select_width;
	while (width--)
		if FD_ISSET (width, &rfdset)
			return(TRUE);

	width = select_width;
	while (width--)
		if FD_ISSET (width, &wfdset)
			return(TRUE);

	width = select_width;
	while (width--)
		if FD_ISSET (width, &efdset)
			return(TRUE);
	return(FALSE);
}

init_select()
{
	FD_ZERO(&rfdset);
	FD_ZERO(&wfdset);
	FD_ZERO(&efdset);
}

/* keep this function around for debugging */
/*
print_fdset(set)
fd_set  *set;
{
	int width = select_width;

	fprintf(stderr, "select on descriptors ");
	while (width--)
		if FD_ISSET (width, set)
			fprintf(stderr, "%d ", width);
	fprintf(stderr, "\n");
}
*/
