/* Copyright (C) 1992 Imperial College */
#include <time.h>
#include "primitives.h"
#include <errno.h>

#ifdef GNUDOS
#include <std.h>
#include "dos/clock.h"
#endif

extern clock_t clock();
extern time_t time();

/* binds argument to CPU time (in milliseconds) */
bool
pr_time()
{
    cellpo reg1;
    clock_t t	= clock() / (CLOCKS_PER_SEC / 1000);

    (void) gc_test(3L, 1);

    reg1 = &A[1]; delnk(reg1);
    if (NotVar(reg1))
	throw(209);

    mkreset(reg1);
    mkint1(reg1, t);
    return(SUCCEED);
}

bool
pr_realtime()
{
    cellpo reg1;
    time_t t = time((time_t *) NULL);

    (void) gc_test(3L, 1);

    reg1 = &A[1]; delnk(reg1);
    if (NotVar(reg1))
	throw(209);

    mkreset(reg1);
    mkint1(reg1, t);
    return(SUCCEED);
}

bool
pr_ctime()
{
	cellpo reg1 =		&A[1];
	cellpo year =		&A[2];
	cellpo month =		&A[3];
	cellpo day =		&A[4];
	cellpo hour =		&A[5];
	cellpo minutes =	&A[6];
	cellpo sec =		&A[7];

	delnk(reg1);
	delnk(year);
	delnk(month);
	delnk(day);
	delnk(hour);
	delnk(minutes);
	delnk(sec);

	if (IsVar(reg1)) {
		struct tm t;

		t.tm_year = intvl(year);
		t.tm_mon = intvl(month);
		t.tm_mday = intvl(day);
		t.tm_hour = intvl(hour);
		t.tm_min = intvl(minutes);
		t.tm_sec = intvl(sec);
		if (gc_test(3L, 7))
			reg1 = &A[1]; delnk(reg1);
		mkreset(reg1);
		mkint1(reg1, timelocal(&t));
	} else {
		struct tm *t;

		time_t ck;
		if (IsInt(reg1))
			ck = intvl(reg1);
		else if (IsFloat(reg1))
			ck = floatvl(reg1);
		else
			return(FAIL);
		t = localtime(&ck);
		mkreset(year);
		mkint(year, t->tm_year);
		mkreset(month);
		mkint(month, t->tm_mon);
		mkreset(day);
		mkint(day, t->tm_mday);
		mkreset(hour);
		mkint(hour, t->tm_hour);
		mkreset(minutes);
		mkint(minutes, t->tm_min);
		mkreset(sec);
		mkint(sec, t->tm_sec);
	}
	return(SUCCEED);
}

bool pr_runtime()
{
	double t;
	int st, lt;
	cellpo arg1, arg2;

	(void) gc_test(6L, 2);

	arg1 = &A[1]; delnk(arg1);
	arg2 = &A[2]; delnk(arg2);

	if (NotVar(arg1) || NotVar(arg2))
		throw(209);

	t = usertime();
	st = (t - TH->stats.starttime)*1000;
	lt = (t - TH->stats.lasttime)*1000;

	TH->stats.lasttime = t;

	mkreset(arg1);
	mkint1(arg1, st);

	mkreset(arg2);
	mkint1(arg2, lt);

	return(SUCCEED);
}

/* return time in seconds */
#include <sys/time.h>
#include <sys/resource.h>

double usertime()
{
	struct rusage buffer;

	(void) getrusage(RUSAGE_SELF,&buffer);
	return((double) buffer.ru_utime.tv_sec + (double) buffer.ru_utime.tv_usec/1.0e6);
}

bool pr_errno()
{
	int err;
	cellpo pt, msg;
	extern char *sys_errlist[];
	extern int sys_nerr;

	pt = &A[1]; delnk(pt);
	msg = &A[2]; delnk(msg);
	if (NotVar(msg))
		return(FAIL);
	if (IsVar(pt)) {
		err = errno;
		mkreset(pt);
		mkint(pt, err);
	} else if (IsInt(pt)) {
		err = intvl(pt);
		if ((err < 0) || (err >= sys_nerr))
			return(FAIL);
	}
	(void) bind_symbol(2, sys_errlist[err], 2);
	return(SUCCEED);
}

bool pr_gc_usage()
{
	cellpo arg1, arg2, arg3;

	(void) gc_test(3L, 3);

	arg1 = &A[1]; delnk(arg1);	/* time */
	arg2 = &A[2]; delnk(arg2);	/* size */
	arg3 = &A[3]; delnk(arg3);	/* count */
	if (NotVar(arg1) || NotVar(arg2) || NotVar(arg3))
		throw(209);
	
	mkreset(arg1);
	alloc_float(arg1, (TH->stats.gc_time * 1000));
	mkreset(arg2);
	mkint(arg2, (TH->stats.gc_acc * sizeof(cell)));
	mkreset(arg3);
	mkint(arg3, TH->stats.gc_count);

	return(SUCCEED);
}
