/* Copyright (C) 1992 Imperial College */
/*--------------------------------------------------------------*
 *								*
 *		Term Examination and Conversion			*
 *								*
 *--------------------------------------------------------------*/

/*
  10/4/90	dac
	In primitives which use heap space, arguments have to be
	reloaded from the A-registers after gc.
  16/2/90	changes to pr_name and pr_tuple_to_list
	do <x>_to_list rather than list_to_<x> because the list
	may not be completely ground.
*/

#include "primitives.h"
#define MAXSTR	4000

extern bool	samesymb();
extern bool	icp_unify();

#ifdef ANSI
#else
extern char	*sprintf();
#endif

/* tag tests */

bool
pr_integer()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsInt(reg1));
}

bool
pr_number()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsInt(reg1) || IsFloat(reg1));
}

bool
pr_float()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsFloat(reg1));
}

bool
pr_atom()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsSymb(reg1));
}

bool
pr_var()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsVar(reg1));
}

bool
pr_list()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsList(reg1) || IsNil(reg1));
}

bool
pr_tpl()
{
    register cellpo reg1 = &A[1];
    delnk(reg1);
    return(IsTpl(reg1));
}

/*------------------------------------------------------------*/

bool
pr_tag()
{
    register cellpo reg1 = &A[1];
    register cellpo reg2 = &A[2];
    delnk(reg1);
    delnk(reg2);
    if (IsVar(reg2)) {
	if (reg1 == reg2)	/* special case : tag(X,X) fails */
	    return(FAIL);
	mkreset(reg2);
	mkint(reg2, tgVal(reg1));
	return(SUCCEED);
    }
    else return(tgVal(reg1) == intvl(reg2));
}

/*------------------------------------------------------------*/

bool
pr_grnd_funct()
{
    register cellpo reg1 = &A[1];
    register cellpo funct;
    delnk(reg1);
    if (IsTpl(reg1)) {
	funct = functor(reg1);
	delnk(funct);
	return(NotVar(funct));
    }
    else return(FAIL);
}

/*------------------------------------------------------------*/

/* A[1] is assumed to be a tuple */
bool
pr_arity()
{
    register cellpo reg1 = &A[1],
		    reg2 = &A[2];
    delnk(reg1);
    delnk(reg2);
    if (IsVar(reg2)) {
	mkreset(reg2);
	mkint(reg2, arity(reg1));
	return(SUCCEED);
    }
    else return(arity(reg1) == intvl(reg2));
}

/*------------------------------------------------------------*/

/* A[1] is assumed to be a tuple */
bool
pr_funct()
{
    register cellpo reg1 = &A[1],
		    reg2 = &A[2];
    delnk(reg1);
    return(icp_unify(reg2, functor(reg1)));
}

/*------------------------------------------------------------*/

/* A[1] is assumed to be an integer, A[2] is tuple */
bool
pr_getarg()
{
    register cellpo reg1 = &A[1];
    register cellpo reg2 = &A[2];
    register cellpo reg3 = &A[3];

    delnk(reg1);
    delnk(reg2);

    if (intvl(reg1) < 0 || intvl(reg1) >= arity(reg2))
	return(FAIL);

    return(icp_unify(reg3, arg(reg2, intvl(reg1))));
}

/*------------------------------------------------------------*/

/* A[1] is assumed to be an integer, A[2] is a variable */
bool
pr_ntpl()
{
    register cellpo reg1 = &A[1];
    register cellpo tup = &A[2];
    fourBytes len;

    delnk(reg1);

    if (intvl(reg1) <= 0)
	return(FAIL);

    len = intvl(reg1);
    /* enough heap space ? */
    (void)gc_test(len+1, 2);

    /* create the tuple of unbound variables */
    delnk(tup);
    mkreset(tup);
    alloc_tpl(tup, tup, len);

    while (len--) {
	mkunb(tup);
	tup++;
    }

    return(SUCCEED);
}

/*------------------------------------------------------------*/

/* "=.." (univ) primitive */

/* converts a list to a tuple - assumes both args are already delinked */
bool
list_to_tuple(lst, tup)
cellpo	lst, tup;
{
    register
    cellpo	el = lst;
    fourBytes	len = 0;

    /* find length of list */
    while(IsList(el)) {
	len++;
	el = tl(el);
	delnk(el);
    }

    /* fail if list is not terminated by a [] */
    if (NotNil(el))
	throw(211);

    /* enough heap space ? */
    if (gc_test(len+1, 2)) {
	tup = &A[1];
	lst = &A[2];
	delnk(tup);
	delnk(lst);
    }

    /* create the tuple and fill it in */
    alloc_tpl(tup, tup, len);
    while(NotNil(lst)) {
	el = hd(lst);
	delnk(el);
	*tup++ = *el;
	lst = tl(lst);
	delnk(lst);
    }

    return(SUCCEED);
}

/* converts a tuple to a list - assumes both args are already delinked */
bool
tuple_to_list(tup, lst)
cellpo	tup, lst;
{
    register
    cellpo	el;
    fourBytes	len = arity(tup);

    tup = (cellpo) vl(tup);

    while (len-- > 0) {
	el = ++tup;
	delnk(el);
	alloc_list(lst, lst);
	*lst++ = *el;
    }
    mknil(lst);

    return(SUCCEED);
}

/* the univ primitive itself - this calls one of the two procedures above */
bool
pr_tuple_to_list()
{
    register cellpo tup = &A[1];
    register cellpo lst = &A[2];
    cellpo lst1;

    delnk(tup);

    if (IsTpl(tup)) {

	/* enough heap space ? */
	if (gc_test(2*arity(tup)+1, 2)) {
	    tup = &A[1];
	    delnk(tup);
	}

	delnk(lst);
	if (IsVar(lst)) {
	    mkreset(lst);
	    return(tuple_to_list(tup, lst));
	}
	else if (IsList(lst)) {
	    alloc_cell(lst1);
	    if (IsList(lst) && tuple_to_list(tup, lst1)) {
		return(icp_unify(lst1, lst));
	    }
	}
    }

    else {
	delnk(lst);
	if (IsVar(tup) && IsList(lst)) {
	    mkreset(tup);
	    return(list_to_tuple(lst, tup));
	}
    }

    throw(210);
}

/*------------------------------------------------------------*/

bool
list_to_symbol(list, symb)
cellpo	list, symb;
{
    cellpo	lst = list, el;
    uchar	cstring[MAXSTR];
    strpo	ptr = cstring;

    /* validate list, pre-determine length and hash value of symbol */
    while(IsList(lst)) {
	el = hd(lst);
	delnk(el);
	if (NotInt(el) || intvl(el) < 0 || intvl(el) > 0xFF)
	    throw(212);
	*ptr++ = intvl(el);
	lst = tl(lst);
	delnk(lst);
    }
    *ptr = '\0';

    /* fail if list is not terminated by a [] */
    if (NotNil(lst))
	throw(211);

    /* create the symbol */
    (void) bind_symbol(1, cstring, 2);
    return(SUCCEED);
}

bool
symbol_to_list(cons, list)
cellpo	cons, list;
{
    register
    strpo	conpo = string_val(cons);
    cellpo	lst = list;
    fourBytes	length = (fourBytes)string_len(cons);

    while (length--) {
	alloc_list(lst, lst);
	mkint(lst, *conpo++);
	lst++;
    }

    mknil(lst);

    return(SUCCEED);
}

bool
list_to_int(list, num)
cellpo	list, num;
{
    register
    cellpo	lst = list, el;
    int		sign = 1;
    fourBytes	total = 0;

    /* check for negative number */
    el = hd(lst);
    delnk(el);
    if (IsInt(el) && intvl(el) == '-') {
	sign = -1;
	lst = tl(lst);
	delnk(lst);
	if (IsNil(lst))		/* a minus sign on its own */
	    return(FAIL);
    }

    /* get the digits */
    while(IsList(lst)) {
	el = hd(lst);
	delnk(el);
	if (NotInt(el) ||
	    intvl(el) < '0' ||
	    intvl(el) > '0' + 9)
	    return(FAIL);
	total = total * 10 + (intvl(el) - '0');
	lst = tl(lst);
	delnk(lst);
    }

    /* fail if list is not terminated by a [] */
    if (NotNil(lst))
	throw(211);

    mkint1(num, (total * sign));
    return(SUCCEED);
}

/* the largest 32-bit number is 10 digits long */
#define MAXDIGITS	10
bool
int_to_list(num, list)
cellpo	num, list;
{
    register
    fourBytes	number = intvl(num), i = 0;
    cellpo	el;
    twoBytes	digits[MAXDIGITS];
 
    if (number < 0) {
	alloc_list(list, el);
	mkint(el, '-');
	list = tl(list);
	number = -number;
    }

    if (number)
	while (number > 0) {
	    digits[i++] = number % 10;
	    number /= 10;
	}
    else digits[i++] = 0;	/* the number is 0 */

    while (i-- > 0) {
	alloc_list(list, el);
	mkint(el, (digits[i] + '0'));
	list = tl(list);
    }

    mknil(list);

    return(SUCCEED);
}

bool
list_to_float(list, flt)
cellpo	list, flt;
{
    register
    strpo	conpo;
    cellpo	el;
    uchar	ch[80], c;
    FLOAT	fl_num;
    double	dummy;
    fourBytes	num;

    conpo = ch;
    while(IsList(list)) {
	el = hd(list);
	delnk(el);
	if (NotInt(el) || intvl(el) < 0 || intvl(el) > 0xFF)
	    throw(212);
	*conpo++ = intvl(el);
	list = tl(list);
	delnk(list);
    }

    /* fail if list is not terminated by a [] */
    if (NotNil(list))
	throw(211);

    /* leave markers */
    *conpo++ = '$';
    *conpo = '\0';

    if (sscanf(ch, "%lf%c", &dummy, &c) != 2 || c != '$')
	return(FAIL);
    fl_num = dummy;

    /* convert to an integer if possible */
    num = fl_num;
    if (num == fl_num) {
	mkint1(flt, num);
	return(SUCCEED);
    }

    /* enough heap space ? */
    if (gc_test(3L, 2)) {
	flt = &A[1];
	delnk(flt);
    }
    alloc_float(flt, fl_num);
    return(SUCCEED);
}

bool
float_to_list(ch, list)
strpo	ch;
cellpo	list;
{
    cellpo el;
    if (*ch == '-') {
	alloc_list(list, el);
	mkint(el, *ch);
	list = tl(list);
	ch++;
    }
#ifndef SUNOS41
    /* hack around SUNOS 4.0 printf("%g") bug : 0.1 is printed as .1 */
    if (*ch == '.') {
	alloc_list(list, el);
	mkint(el, '0');
	list = tl(list);
    }
#endif
    while (*ch) {
	alloc_list(list, el);
	mkint(el, *ch);
	list = tl(list);
	ch++;
    }
    mknil(list);
    return(SUCCEED);
}

bool
pr_name()
{
    register cellpo cons = &A[1];
    register cellpo list = &A[2];
    cellpo mode_reg = &A[3];	/* 0=name, 1=atom_chars, 2=number_chars */
    int mode;
    cellpo term1;

	delnk(mode_reg);
	if (!IsInt(mode_reg))
		throw(210);
	mode = intvl(mode_reg);
	if (mode < 0  || mode > 2)
		throw(210);

    delnk(cons);

    if (IsSymb(cons)) {
	if (mode == 2)		/* number_chars */
		return(FAIL);

	/* enough heap space ? */
	if (gc_test((fourBytes)(2*string_len(cons)+1), 2)) {
	    cons = &A[1];
	    delnk(cons);
	}

	delnk(list);
	if (IsVar(list)) {
	    mkreset(list);
	    return(symbol_to_list(cons, list));
	}
	else {
	    alloc_cell(term1);
	    if (IsList(list) && symbol_to_list(cons, term1))
		return(icp_unify(term1, list));
	}
    } else if (IsInt(cons)) {
	if (mode == 1)		/* atom_chars */
		return(FAIL);

	/* enough heap space ? */
	if (gc_test((fourBytes)(2*(MAXDIGITS+1)+1), 2)) {
	    cons = &A[1];
	    delnk(cons);
	}

	delnk(list);
	if (IsVar(list)) {
	    mkreset(list);
	    return(int_to_list(cons, list));
	}
	else {
	    alloc_cell(term1);
	    if (IsList(list) && int_to_list(cons, term1))
		return(icp_unify(term1, list));
	}
    } else if (IsFloat(cons)) {
	uchar ch[80];
	if (mode == 1)		/* atom_chars */
		return(FAIL);
	(void)sprintf(ch, "%.16lg", floatvl(cons));
	(void)gc_test((fourBytes)(2*(strlen(ch)+1)), 2);

	delnk(list);
	if (IsVar(list)) {
	    mkreset(list);
	    return(float_to_list(ch, list));
	}
	else {
	    alloc_cell(term1);
	    if (IsList(list) && float_to_list(ch, term1))
		return(icp_unify(term1, list));
	}
    } else if (IsVar(cons)) {
	delnk(list);
	if (IsVar(list))
	    throw(210);
	if (IsList(list)) {
	    mkreset(cons);
		switch(mode) {
			case 0:	/* name */
				if (list_to_int(list, cons))
					return(SUCCEED);
				else if (list_to_float(list, cons))
					return(SUCCEED);
				else return(list_to_symbol(list, cons));
				break;
			case 1:	/* atom_chars */
				return(list_to_symbol(list, cons));
				break;
			case 2:	/* number_chars */
				if (list_to_int(list, cons))
					return(SUCCEED);
				else
					return(list_to_float(list, cons));
				break;
		}
	}
    }

    return(FAIL);
}

/*------------------------------------------------------------*/

bool
pr_addr(TH)
threadpo TH;
{
    register cellpo var = &A[1];
    register cellpo num = &A[2];

    delnk(var);
    delnk(num);

    if (IsVar(var) && IsVar(num)) {
	mkint1(num, normal(vl(var)));
	return(SUCCEED);
    }
    else throw(209);
}

/*------------------------------------------------------------*/

utwoBytes
write_number(number, dest)
fourBytes number;
strpo *dest;
{
    twoBytes	digits[MAXDIGITS];
    register
    utwoBytes	i = 0,
		len = 0;

    if (number < 0) {
	*(*dest)++ = (CHARTYPE)'-';
	number = -number;
	len++;
    }
    if (number)
	while (number > 0) {
	    digits[i++] = number % 10;
	    number /= 10;
	}
    else digits[i++] = 0;	/* the number is 0 */

    len += i;
    while (i--)
	*(*dest)++ = (CHARTYPE)('0' + digits[i]);
    *(*dest) = '\0';
    return(len);
}

/* joins two symbols or integers - the resulting symbol can be at most 255 characters */
bool
pr_concat()
{
    uchar	ch[255];
    register strpo	pt;
    strpo	whole = ch;
    utwoBytes	len = 0;
    cellpo	pre  = &A[1];
    cellpo	post = &A[2];
    cellpo	sym  = &A[3];

	/* At least 2 must be non ground */
	delnk(pre);
	if (!IsVar(pre)) {
		if (IsSymb(pre)) {
			pt = string_val(pre);
			len = string_len(pre);
			while(*whole = *pt++)
				whole++;
		} else if (IsInt(pre))
			len = write_number(intvl(pre), &whole);
		else
			throw(210);
		delnk(post);
		if (!IsVar(post)) {
			if (IsSymb(post)) {
				pt = string_val(post);
				len += string_len(post);
				while(*whole = *pt++)
					whole++;
			} else if (IsInt(post))
				len += write_number(intvl(post), &whole);
			else throw(210);
			delnk(sym);
			if (IsVar(sym)) {
				(void) bind_symbol(3, ch, 3);
				return(SUCCEED);
			} else if (IsSymb(sym)) {
				if (!strcmp(string_val(sym), ch))
					return(SUCCEED);
				else
					return(FAIL);
			} else
				throw(210);
		} else if (IsSymb(sym)) { /* post is var */
			if (len > string_len(sym))
				return(FAIL);
			pt = string_val(sym);
			if (strncmp(pt, ch, (int) len))
				return(FAIL);
			pt += len;
			for (len = 0, whole = ch; *whole = *pt++; len++)
				whole++;
			(void) bind_symbol(2, ch, 3);
			return(SUCCEED);
		} else
			throw(210);
	} else if (IsSymb(sym)) { /* pre is a variable, sym is a symbol */
		delnk(post);
		delnk(sym);
		pt = string_val(sym);
		if (IsSymb(post)) {
			if (string_len(sym) < string_len(post))
				return(FAIL);
			len = string_len(sym) - string_len(post);
			if (strcmp((pt+len), string_val(post)))
				return(FAIL);
			(void) strncpy(ch, pt, (int) len);
			ch[len] = '\0';
		} else if (IsInt(post)) {
			len = write_number(intvl(pre), &whole);
			if (strcmp((pt+len), ch))
				return(FAIL);
		} else
			throw(210);
		(void) bind_symbol(1, ch, 3);
		return(SUCCEED);
	} else
		throw(210);
}

bool
pr_prefix()
{
    register cellpo sym  = &A[1];
    register cellpo pre  = &A[2];
    utwoBytes	len;
    strpo	str1, str2;

    delnk(sym);
    delnk(pre);

    if (NotSymb(sym) || NotSymb(pre))
	return(FAIL);

    if ((len=string_len(pre)) > string_len(sym))
	return(FAIL);

    str1 = string_val(pre);
    str2 = string_val(sym);

    while (len--)
	if (*str1++ != *str2++)
	    return(FAIL);

    return(SUCCEED);
}

bool
pr_suffix()
{
    register cellpo sym  = &A[1];
    register cellpo suf  = &A[2];
    utwoBytes	len, lensym;
    strpo	str1, str2;

    delnk(sym);
    delnk(suf);

    if (NotSymb(sym) || NotSymb(suf))
	return(FAIL);

    lensym = string_len(sym);
    if ((len=string_len(suf)) > lensym)
	return(FAIL);

    str1 = string_val(suf);
    str2 = string_val(sym) + (lensym-len);

    while (len--)
	if (*str1++ != *str2++)
	    return(FAIL);

    return(SUCCEED);
}

/*------------------------------------------------------------*/

typedef struct gensymList {
    strpo		root;
    int			count;
    struct gensymList	*next;
} *gensympo;

/* keep track of counts for each basename */
gensympo gensymlist = NULL;

bool
pr_gensym()
{
    register cellpo base = &A[1];
    register cellpo new  = &A[2];

    gensympo	ptr;
    strpo	name;

    delnk(base);
    delnk(new);

    if (NotSymb(base) || NotVar(new))
	throw(210);

    ptr = gensymlist;
    while (ptr && strcmp(ptr->root, string_val(base)))
	ptr = ptr->next;

    if (!ptr) {
	ptr = (gensympo) malloc(sizeof(struct gensymList) +
				string_len(base) + 1);
	name = (strpo)(ptr + 1);
	(void) strcpy(name, string_val(base));
	ptr->root = name;
	ptr->count = 0;
	ptr->next = gensymlist;
	gensymlist = ptr;
    }

    ptr->count++;

    A[3] = A[2];
    mkint(&A[2], ptr->count);
    return(pr_concat());
}
