/* Copyright (C) 1992 Imperial College */
/*
    termio.h - definitions for use in the term level input output functions
    Written by Frank McCabe, Damian Chu and Philip Schwarz.
    Imperial College, Winter 1989
*/

typedef enum {  sep, punct, solo, graph, upper, lower,
		number, floating, string, quoted, eof_token  } char_t;

/* the following type is the same as char_t above, except for the case of
   class 'punct', where the value is the actual punctuation character */
typedef char toktype;



/* length of longest token */
#define MAXTOKBUFFER 1000

/* structure of a token */
typedef struct {
    toktype tt;
    unsigned long bufflen;
    uchar buff[MAXTOKBUFFER];
} token;



/* priority of minimum precedence term */
#define minprior 	1201
/* priority of an argument term to a list or compound term */
#define argprior 	999
/* priority of an undefined operator */
#define undefprior	2000

/* maximum size of a tuple term expressed as a number of arguments */
#define MAXARG		100

/* maximum number of characters in an operator symbol */
#define MAXOPLEN	32



/* definition of an operator table entry */
typedef struct {
    uchar 	op[MAXOPLEN];	/* The operator itself */
    fourBytes	hsh;		/* Hash value of operator */
    twoBytes	prefixp,	/* Its prefix precedence */
		preform,	/* Prefix right prec */
		infleft,	/* Infix left priority */
		infixp,		/* Its infix precedence */
		infright,	/* Infix right priority */
		postleft,	/* Postfix left priority */
		postfixp;	/* Its postfix precedence */
    twoBytes    lnk;		/* The link */
} operator, *operatorpo;

#define FREE		-1

extern	char_t		*chtypes;
#define	chtype(ch)	(*(chtypes+(ch)))

#define slash		'/'
#define backslash	'\\'
#define bra		'('
#define ket		')'
#define sqbra		'['
#define sqket		']'
#define space		' '
#define brace		'{'
#define endbrace	'}'
#define dot		'.'
#define comma		','
#define semicolon	';'
#define bar		'|'
#define minus		'-'
#define plus		'+'
#define star		'*'
#define percent		'%'
#define tab		'\t'
#define quote		'\''
#define dquote		'\"'
#define caret		'^'
