/* Copyright (C) 1992 Imperial College */
/*--------------------------------------------------------------*
 *								*
 *			Interface to Unix			*
 *								*
 *--------------------------------------------------------------*/

#include "primitives.h"
#ifndef THINK_C
#undef size_t
#include <sys/types.h>
#include <sys/stat.h>
extern int	chdir();
extern char     *getenv();
#endif

extern int	signal_mask;

bool
pr_unix()
{
#ifdef THINK_C
    (void) fprintf(stderr, "\nunix/1 is not available in THINK_C\n");
    return(FAIL);
#else
    cellpo	reg1 = &A[1];
    strpo	command;
    int		status, old_mask;
    

    delnk(reg1);
    if (NotSymb(reg1))
	throw(210);

    command = string_val(reg1);

    if (!strncmp(command, "cd", 2)) {
	if (command[2] ==  ' ')
	    return(chdir(&command[3]) ? FAIL : SUCCEED);
	else if (command[2] == '\0')
	    return(chdir(getenv("HOME")) ? FAIL : SUCCEED);
    }

    timeslice(0);
    old_mask = sigblock(signal_mask);
    status = system(command);
    (void) sigsetmask(old_mask);
    timeslice(1);
    return(status ? FAIL : SUCCEED);
#endif
}

bool
pr_getenv()
{
	cellpo arg1 = &A[1], arg2 = &A[2];
	char *ret;

	delnk(arg1);
	if (NotSymb(arg1))
		return(FAIL);
	delnk(arg2);
	if (NotVar(arg2) && NotSymb(arg2))
		return(FAIL);
	if (!(ret = getenv(string_val(arg1))))
		return(FAIL);

	if (IsVar(arg2)) {
		(void) bind_symbol(2, ret, 2);
		return(SUCCESS);
	} else if (!strcmp(ret, string_val(arg2)))
		return(SUCCESS);
	return(FAIL);
}

#define MAXENV	300

bool
pr_setenv()
{
	cellpo arg1 = &A[1], arg2 = &A[2];
	char	*sbuf, *s, *val;
	double	f;

	delnk(arg1);
	delnk(arg2);

	if (NotSymb(arg1) ||
	   (NotSymb(arg2) && NotInt(arg2) && NotFloat(arg2)))
		return(FAIL);

	sbuf = (char *)malloc(MAXENV);
	strcpy(sbuf, string_val(arg1));
	strcat(sbuf, "=");
	s = sbuf + strlen(sbuf);
	if (IsSymb(arg2))
		strcpy(s, string_val(arg2));
	else if (IsInt(arg2))
		(void) sprintf(s, "%d", intvl(arg2));
	else { /* a float */
		f = floatvl(arg2);
		(void) sprintf(s, "%g", f);
		/*  ensure string contains a decimal point  */
		if (!index(s, '.')) {
			if (index(s,'e'))
				(void) sprintf(s, "%.1e", f);
			else	(void) sprintf(s, "%.1f", f);
		}
	}
	if (putenv(sbuf) == 0) {
		if (strcmp(string_val(arg1), "ICP_PATH") == 0)
			update_directories();
		return(SUCCESS);
	}
	else
		return(FAIL);
}

/*	stat(+Filename, -AbsFile, -ModTime, -Size, -Mode, -UserId, -GroupId)	*/
bool
pr_stat()
{
	cellpo	arg1 = &A[1], arg2 = &A[2], arg3 = &A[3],
		arg4 = &A[4], arg5 = &A[5], arg6 = &A[6], arg7=&A[7];
	struct stat buf;
	char name[MAXFILENAME];

	/* make sure enough space for 2 floats */
	(void) gc_test(8L, 6);

	delnk(arg1);
	if (NotSymb(arg1)) return(FAIL);
	
	delnk(arg2);
	if (NotVar(arg2)) return(FAIL);

	delnk(arg3);
	if (NotVar(arg3)) return(FAIL);

	delnk(arg4);
	if (NotVar(arg4)) return(FAIL);

	delnk(arg5);
	if (NotVar(arg5)) return(FAIL);

	delnk(arg6);
	if (NotVar(arg6)) return(FAIL);

	delnk(arg7);
	if (NotVar(arg7)) return(FAIL);

	if (!ic_file_name_stats(string_val(arg1), name, TRUE, &buf))
		return(FAIL);
	mkreset(arg3); mkint1(arg3, buf.st_mtime);
	mkreset(arg4); mkint1(arg4, buf.st_size);
	mkreset(arg5); mkint(arg5, buf.st_mode);
	mkreset(arg6); mkint(arg6, buf.st_uid);
	mkreset(arg7); mkint(arg7, buf.st_gid);
	(void) bind_symbol(2, name, 7);
	return(SUCCESS);
}
