%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             C C S     V E R I F I C A T I O N     T O O L
%
%              (Calculus of Communicating Processes by R.Milner)
%
%                 Author: Mantis H.M. Cheng (Oct/28/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% To generate an interpreted version, follow these steps:
%  1. Uncomment the block of statements between "Interpreted version".
%  2. Comment the block of statements between "Compiled version".
%  3. Save this file.
%  4. Edit the file "parser.pl". 
%  5. Uncomment the line ":- dynamic operatorN/3 ...".
%  6. Save the changes.
%  7. Start prolog and consult "ccsv".
%     | ?- [ccsv].
%

/*
%
% Interpreted version
%
:- [parser,type,builtin].   		         % front-end
:- [command].                                    % the command interpreter
:- [lts,bisim,temporal,verify,trace,term,util].  % back-end
%
% End of Interpreted version
%
*/

%
% To generate a compiled version, follow these steps:
%  1. comment the block of statements between "Interpreted version".
%  2. Uncomment the block of statements between "Compiled version".
%  3. Save this file.
%  4. Edit the file "parser.pl". 
%  5. Comment the line ":- dynamic operatorN/3 ...".
%  6. Save the changes.
%  7. Start prolog and then compile "ccsv".
%     | ?- compile(ccsv).
%  8. Wait for CCS/MMC prompt and then type "save_state(ccsv)."
%  9. We now have a saved core image of the system in "ccsv".
%

%
% Compiled version
%
:- prolog_flag( compiling, compactcode, fastcode ).

:- compile([parser,type,builtin]).
:- compile([command]). 
:- compile([lts,bisim,temporal,verify,trace,term,util]).
%
% End of Compiled version
%

%
% To add a new built-in operator and/or change the operator declarations:
%  1. Remove the file "builtin.pl".
%  2. Edit the file "predefined.op" to make any necessary changes.
%  3. Start the Interpreted version of CCS.
%     (It will complain that file "builtin.pl" not found.)
%  4. Wait for CCS/MMC prompt and then type "load('predefined.op')."
%  5. After the operator declarations have been loaded, type
%       [> save_ops('builtin.pl').
%     Now, we have a new "builtin.pl" file containing the current operator
%     declaration.
%  6. Exit the system and restart.
%

banner :- 
	write('CCSV (v.1.0 UVIC/CS)'), nl,
	write('Type "help." for help' ), nl.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                B O O T I N G    T H E    S Y S T E M
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- banner, ccsv.

