%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             T Y P E / W E L L - F O R M E D      C H E C K E R
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Definitions must be of the form:
%
%  <Defn> ::= <Const> "::=" ( <Agent> | <Form> )
%
% where free variables in (<Agent>|<Form>) must be defined in <Const>
%
semantic_check(op('::=',Const, Body),op('::=',Const1,Body1),Env) :-
	semantic_check_const(Const, Const1, [], Env),
          % free variables in "Body" should be defined in "Env"
	( semantic_check_agent(Body, Body1, Env ) ;
	  semantic_check_formula(Body,Body1, Env) ),
	!.
semantic_check(_,_,_ ) :-
	write( '*** expression not well-formed ***' ), nl,
	fail.


%
% <Const>  ::= <Uid> [ "(" <Exp> { "," <Exp> } ")" ]
%
semantic_check_const( uid(T), uid(T), Env, Env ) :- !.
semantic_check_const( func(uid(F),N,Ts), func(uid(F),N,Ts1), Env1, Env2 ) :-
	!,
	semantic_check_exp( Ts, Ts1, Env1, Env2 ).

%
% <Exp> ::=  <String>
%          | <Boolean>
%          | <Number>
%          | <lid>
%          | <lid> "(" <Exp> ... <Exp> ")"
%          | "[" <Exp> ... <Exp> "]"
%          | <Exp> <Op> <Exp>   where Op is +, -, *, <, >, =<, >=, <>
%          | <Variable>
%	   | <Formula>
%
semantic_check_exp( const(T), const(T), E, E ) :- !.
semantic_check_exp( bool(T) , bool(T) , E, E ) :- !.
semantic_check_exp( num(T)  , num(T)  , E, E ) :- !.
semantic_check_exp( lid(X)  , lid(X)  , E, E ) :- !.       
semantic_check_exp( var(X)  , V       , E1,E2 ) :- !,
	new_var( E1, E2, X, V ).
semantic_check_exp( func(lid(X),N,Ts), func(lid(X),N,Ts1), E1, E2) :- !,
	semantic_check_exp(Ts, Ts1, E1, E2 ).
semantic_check_exp( [], [], E, E ) :- !.
semantic_check_exp( [T|Ts], [T1|Ts1], E1, E3 ) :- !,
	semantic_check_exp( T, T1, E1, E2 ),
	semantic_check_exp( Ts, Ts1, E2, E3 ).
semantic_check_exp( F, F1, E, E ) :-
	semantic_check_formula( F, F1, E ), !.
  % any binary arithmetic operators
semantic_check_exp( op(O,L,R), op(O,L1,R1), E1, E3 ) :-
	semantic_check_exp( L, L1, E1, E2 ),
	semantic_check_exp( R, R1, E2, E3 ).


%
% <Agent> ::= 
%           | "STOP"
%           | "SKIP"
%           | "fix" <Uid> "."    <Agent>
%           | <Agent>    "|||"   <Agent>
%           | <Agent>    "|>"    <Agent>
%           | <Agent>    ";"     <Agent>
%           | <Agent>    "||"    <Agent>
%           | <Agent>    "or"    <Agent>
%           | <Agent>    "+"     <Agent>
%           | <Agent>    "\"     <Hide>
%           | <Agent>    "/"     <Trace>
%           | <Agent>    "^"     <Sync>
%           | <Agent>    "#"     <Renames>
%           | "if" <Exp> "then"  <Agent>
%           | "@" <Agent>
%           | <Prefixes>
%           | <Con>
%
semantic_check_agent( 'STOP', 'STOP', _ ) :- !.
semantic_check_agent( 'SKIP', 'SKIP', _ ) :- !.
semantic_check_agent( op('.',op('fix',uid(C)),A), 
                      op('.',op('fix',uid(C)),A1), E ) :- !,
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op(O,L,R), op(O,L1,R1), E ) :-
        member( O, ['|||','|>',';','||','or','+'] ),
	!,
	semantic_check_agent(L, L1, E ),
	semantic_check_agent(R, R1, E ).
semantic_check_agent( op(O,L,set(As)), op(O,L1,set(As)), E ) :- 
	member( O, ['^','\'] ), !, 
	semantic_check_labels( As ),
	semantic_check_agent( L, L1, E ).
semantic_check_agent( op('/',L,As), op('/',L1,As), E ) :- 
	!,
	semantic_check_labels( As ),
	semantic_check_agent( L, L1, E ).
semantic_check_agent( op('#',A,set(F)), op('#',A1,set(F)), E ) :- !,
	semantic_check_agent( A, A1, E ),
	semantic_check_renames( F ).
semantic_check_agent( ifthen(C,A), ifthen(C1,A1), E ) :- !,
	semantic_check_exp( C, C1, E, E ),
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op('@',A), op('@',A1), E ) :- !,
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op('|',L,R), op('|',L1,R1), E ) :-
	!,
	semantic_check_prefix(L, L1, E ),
	semantic_check_prefixes(R, R1, E ).
semantic_check_agent( op('->',A,L), op('->',A1,L1), E ) :- !,
	semantic_check_prefix( op('->',A,L), op('->',A1,L1), E ).
semantic_check_agent( A, A1, E ) :-
	semantic_check_const( A, A1, E, E ). 


%
% <Prefix>   ::= <Action> -> <Agent>
% <Prefixes> ::= <Prefix>
%              | <Prefix> "|" <Prefixes>
%
semantic_check_prefix(op('->',A,C), op('->',A1,C1), E ) :-
	semantic_check_action( A, A1, E, E1 ),
	semantic_check_agent( C, C1, E1 ).

semantic_check_prefixes( op('|',L,R), op('|',L1,R1), E ) :-
	!,
	semantic_check_prefix( L, L1, E ),
	semantic_check_prefixes( R, R1, E ).
semantic_check_prefixes( op('->',A,L), op('->',A1,L1), E ) :- !,
	semantic_check_prefix( op('->',A,L), op('->',A1,L1), E ).


semantic_check_renames( [] ) :- !.
semantic_check_renames( [op('=',A,B)|L] ) :- 
	ground_label(A), 
	ground_label(B),
	semantic_check_renames( L ).


semantic_check_labels( [] ) :- !.
semantic_check_labels( [A|L] ) :- 
	ground_label( A ),
	semantic_check_labels( L ).


% <Action>   ::= <Label>
%              | <Var> ":" <Labels>
%              | <Channel> "?" <Var>
%              | <Channel> "!" <Exp>
%              | <Action> "&" <Action> { "&" <Action> }
%
semantic_check_action( func(F,N,As), func(F,N,As1), E, E1 ) :- !,
	semantic_check_exp( As, As1, E, E1 ).
semantic_check_action( A, A, E, E ) :-  ground_label(A), !.
semantic_check_action(op(':',var(X),set(As)), op(':',V, set(As)), E, E1 ) :- !,
	new_var( E, E1, X, V ), 
	semantic_check_labels( As ).
semantic_check_action(op('?',lid(C),T), op('?',lid(C),T1), E, E1 ) :- !,
	semantic_check_exp( T, T1, E, E1 ).
semantic_check_action(op('!',lid(C),T), op('!',lid(C),T1), E, E1 ) :- !,
	semantic_check_exp( T, T1, E, E1 ).
semantic_check_action(op('&',A,B), op('&',A1,B1), E, E2 ) :-
	semantic_check_action( A, A1, E, E1 ),
	semantic_check_action( B, B1, E1, E2 ).


%
% new_var( +Env, -Env1, +VarName, -Var )
%
new_var( E1,       E1,      void,   _ ) :- !.
new_var( [],       [X=V],      X,   V ) :- !.
new_var( [X=U|E],  [X=U|E],    X,   U ) :- !.
new_var( [Y=U|E1], [Y=U|E2],   X,   V ) :-
	X \==Y,
	new_var( E1, E2, X, V ).


%
% ground_label( +Label ) holds of "Label" is ground
%
ground_label( A ) :- label( A ), ground_term( A ), !.

label( lid(_)   ).
label( const(_) ).
label( num(_)   ).
label( done     ).
label( func(_,_,_) ).

%
% ground_pure_action( +Action ) holds of "Action" is ground
%
ground_pure_action( A ) :- pure_action( A ), ground_term( A ), !.

pure_action( A ) :- label( A ), !.
pure_action( op('?',lid(_),_) ).
pure_action( op('!',lid(_),_) ).
pure_action( op('$',lid(_),_) ).


% <Formula> ::= 
%             "tt"
%	    | "ff"
%	    | <Var>
%	    | <Const>
%           | <Const> [ "(" <Exp> { "," <Exp> ")" ]
%           | "not" <Formula>
%           | <Formula> "and" <Formula>
%           | <Formula> "or" <Formula>
%	    | <Modal> "." <Formula>
%           | "min" <Const> "." <Formula>
%           | "max" <Const> "." <Formula>
%
semantic_check_formula( form(T),   form(T),   _ ) :- !.
semantic_check_formula( var(X),    V,         E ) :- !, member( X=V, E ).
semantic_check_formula( uid(C),    uid(C),    _ ) :- !.
semantic_check_formula( func(uid(C),N,As), func(uid(C),N,As1), E ) :- !,
	semantic_check_exp( As, As1, E, E ).
semantic_check_formula( op('not',R), op('not',R1), E ) :- !,
	semantic_check_formula(R,R1,E).
semantic_check_formula( op(O,L,R), op(O,L1,R1), E ) :-
        member( O, ['and','or'] ), !,
	semantic_check_formula(L,L1,E),
	semantic_check_formula(R,R1,E).
semantic_check_formula( op('.',op(O,uid(C)),R), op('.',op(O,uid(C)),R1), E ) :-
	member( O, ['min', 'max'] ), !,
	semantic_check_formula(R,R1,E).
semantic_check_formula( op('.',M,R), op('.',M1,R1), E ) :- 
	semantic_check_modal(M,M1,E),
	semantic_check_formula(R,R1,E).


% <Modal>   ::= "[[" <Acts> "]]"
%	    |   "<<" <Acts> "]]"
%
semantic_check_modal( box(A), box(A1), E ) :- !,
	semantic_check_acts(A,A1,E).
semantic_check_modal( diamond(A), diamond(A1), E ) :-
	semantic_check_acts(A,A1,E).


% <Acts>    ::= "-"
%           |  [ "-" ] "{" [ <Act> { "," <Act> } ] "}"
%           |  "[" <Act> { "," <Act> } "]"
%           |  [ "-" ] <Act>
%
semantic_check_acts( '-', '-', _ ) :- !.
semantic_check_acts( op('-',set(As)), op('-',set(As1)), E ) :- !,
	semantic_check_actset( As, As1, E ).
semantic_check_acts( set(As), set(As1), E ) :- !,
	semantic_check_actset( As, As1, E ).
semantic_check_acts( [A|As], [A1|As1], E ) :- !,
	semantic_check_actset( [A|As], [A1|As1], E ).
semantic_check_acts( op('-',A), op('-',A1), E ) :- !,
	semantic_check_act( A, A1, E ).
semantic_check_acts( A, A1, E ) :- 
	semantic_check_act( A, A1, E ).


% <Act>     ::= <Action> | <Var>
%
semantic_check_act( var(X), V, E ) :- !, member( X=V, E ).
semantic_check_act( A,      A, _ ) :- pure_action( A ).


semantic_check_actset( [], [], _ ) :- !.
semantic_check_actset( [A|As], [A1|As1], E ) :- !,
	semantic_check_act( A, A1, E ),
	semantic_check_actset(As,As1,E).

