%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             M I S C E L L A N E O U S    U T I L I T I E S
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% append( +List1, +List2, -List)
%     holds if "List" is the result of concatenating "List1" and "List2"
%
append([],    L, L     ) :- !.
append([X|Xs],L, [X|Ls]) :- append(Xs,L,Ls).


%% member( +Element, +List )
%       holds if "Element" is a member of "List"
%
member(X, [X|_]).
member(X, [_|Z]) :- member(X,Z).


%% non_member( +Element, +List )
%       holds if "Element" is not a member of "List"
%
non_member( _, [] ) :- !.
non_member( X, [Y|Ys] ) :- 
        X \==Y, 
        non_member( X, Ys ).


%% nth( +List,  +N, -Element) 
%       Return the "N"th element in "List", starting from 1.
%       This is deterministic.
%
nth([X|_], 1, X) :- !.
nth([_|L], N, X) :- 
        N > 1, 
        N1 is N-1, 
	nth(L,N1,X).


%% reverse( +ListIn, -ListOut )
%       "ListOut" is "Listin" with its elements in reverse order.
%
reverse(A,B) :- 
        reverse(A,[],B).

reverse([], B, B).
reverse([X|Xs],R,R1) :- reverse(Xs,[X|R],R1).
